export const theme = {
	palette: {
		native: {
			blue: '#2271b1',
			blueActive: '#135e96',
		},
		primary: {
			main: '#F0ABFC',
			light: '#5EEAD4',
			accent: '#524CFF',
		},
		secondary: {
			main: '#515962',
		},
		text: {
			default: '#3A3F45',
			white: '#FFFFFF',
			primary: '#0C0D0E',
			secondary: '#2271B1',
			tertiary: '#69727D',
			lightGrey: '#535961',
			dark: '#26292C',
			darkGrey: '#64666A',
			disabled: '#DDDDDD',
			toast: '#D5DADF',
			noticeInfo: '#1E1E1E',
			link: '#040080',
			brand: '#45f2b6',
		},
		background: {
			default: '#FFFFFF',
			lightGrey: '#F6F7F7',
			grey: '#D9D9D9',
			toast: '#2D2D2D',
			noticeInfo: '#F1F6FB',
			brand: '#040080',
			disabled: '#D5D8DC',
		},
		border: {
			default: '#E6E8EA',
			lightest: '#D5DADF',
			grey: '#D9D9D9',
			grey600: '#949494',
		},
		info: {
			notice: '#0288D1',
			main: '#2563EB',
		},
		success: {
			main: '#5EEAD4',
		},
		warning: {},
		error: {
			main: '#DC2626',
		},
		brand: {
			main: '#93003F',
			hover: '#7e013b',
		},
		badge: {
			background: {
				success: '#E9FCF2',
				danger: '#FDE8EB',
				warning: '#FFF6E6',
			},
			text: {
				success: '#0F6737',
				danger: '#B21027',
				warning: '#8D5E01',
			},
		},
	},
	fonts: {
		default: 'Roboto, sans-serif',
	},
	spacing: {
		1.5: '12px',
	},
};
