<?php
/**
 * RetrieveContactById.
 * php version 5.6
 *
 * @category RetrieveContactById
 * @package  SureTriggers
 * @author   BSF <username@example.com>
 * @license  https://www.gnu.org/licenses/gpl-3.0.html GPLv3
 * @link     https://www.brainstormforce.com/
 * @since    1.0.0
 */

namespace SureTriggers\Integrations\FluentCRM\Actions;

use Exception;
use SureTriggers\Integrations\AutomateAction;
use SureTriggers\Traits\SingletonLoader;

/**
 * RetrieveContactById
 *
 * @category RetrieveContactById
 * @package  SureTriggers
 * @author   BSF <username@example.com>
 * @license  https://www.gnu.org/licenses/gpl-3.0.html GPLv3
 * @link     https://www.brainstormforce.com/
 * @since    1.0.0
 */
class RetrieveContactById extends AutomateAction {


	/**
	 * Integration type.
	 *
	 * @var string
	 */
	public $integration = 'FluentCRM';

	/**
	 * Action name.
	 *
	 * @var string
	 */
	public $action = 'fluentcrm_retrieve_contact_by_id';

	use SingletonLoader;

	/**
	 * Register a action.
	 *
	 * @param array $actions actions.
	 * @return array
	 */
	public function register( $actions ) {

		$actions[ $this->integration ][ $this->action ] = [
			'label'    => __( 'Retrieve Contact By ID', 'suretriggers' ),
			'action'   => $this->action,
			'function' => [ $this, 'action_listener' ],
		];
		return $actions;
	}

	/**
	 * Action listener.
	 *
	 * @param int   $user_id user_id.
	 * @param int   $automation_id automation_id.
	 * @param array $fields fields.
	 * @param array $selected_options selectedOptions.
	 * @return array
	 * @throws Exception Exception.
	 */
	public function _action_listener( $user_id, $automation_id, $fields, $selected_options ) {
		if ( ! function_exists( 'FluentCrmApi' ) ) {
			return [
				'status'  => 'error',
				'message' => __( 'FluentCRM is not active.', 'suretriggers' ), 
				
			];
		}

		$contact_api = FluentCrmApi( 'contacts' );

		$contact = $contact_api->getContact( $selected_options['contact_id'] );

		if ( is_null( $contact ) ) {
			return [
				'message'     => __( 'Can not find the contact with the ID.', 'suretriggers' ),
				'status'      => 'false',
				'user_exists' => 'false',
			];
		}

		$context                   = [];
		$context['user_exists']    = 'true';
		$context['id']             = $contact->id;
		$context['user_id']        = $contact->user_id;
		$context['full_name']      = $contact->full_name;
		$context['first_name']     = $contact->first_name;
		$context['last_name']      = $contact->last_name;
		$context['contact_owner']  = $contact->contact_owner;
		$context['company_id']     = $contact->company_id;
		$context['email']          = $contact->email;
		$context['address_line_1'] = $contact->address_line_1;
		$context['address_line_2'] = $contact->address_line_2;
		$context['postal_code']    = $contact->postal_code;
		$context['city']           = $contact->city;
		$context['state']          = $contact->state;
		$context['country']        = $contact->country;
		$context['phone']          = $contact->phone;
		$context['status']         = $contact->status;
		$context['contact_type']   = $contact->contact_type;
		$context['source']         = $contact->source;
		$context['date_of_birth']  = $contact->date_of_birth;
		$context['tags']           = $contact->tags;
		$context['lists']          = $contact->lists;
		$custom_data               = $contact->custom_fields();
		if ( ! empty( $custom_data ) ) {
			foreach ( $custom_data as $key => $field ) {
				if ( is_array( $field ) ) {
					$context[ $key ] = implode( ',', $field );
				} else {
					$context[ $key ] = $field;
				}
			}
		}
		return $context;
	}

}

RetrieveContactById::get_instance();
